#!/usr/bin/env python

import sys, time
from daemon import Daemon
import syslog
import RPi.GPIO as GPIO

class MyDaemon(Daemon):
	def run(self):
		syslog.openlog(ident="watchdog",logoption=syslog.LOG_PID, facility=syslog.LOG_LOCAL0)
		syslog.syslog('watchdog started...')

		GPIO.setmode(GPIO.BOARD)

		GPIO.setup(18, GPIO.OUT)

		GPIO.output(18, False)

       		while True:
       			GPIO.output(18, True)
			time.sleep(1)
			GPIO.output(18, False)
			time.sleep(20)
        
		syslog.syslog('watchdog stopped...')
        

if __name__ == "__main__":
	daemon = MyDaemon('/tmp/watchdog.pid')
	if len(sys.argv) == 2:
		if 'start' == sys.argv[1]:
			daemon.start()
		elif 'stop' == sys.argv[1]:
			daemon.stop()
		elif 'restart' == sys.argv[1]:
			daemon.restart()
		else:
			print "Unknown command"
			sys.exit(2)
		sys.exit(0)
	else:
		print "usage: %s start|stop|restart" % sys.argv[0]
		sys.exit(2)
